/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org2.eclipse.php.internal.core.ast.locator.Locator;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org2.eclipse.php.internal.core.compiler.ast.nodes.VarComment;

public class CommentsVisitor
extends AbstractVisitor {
    private List<Comment> comments;
    private Map<ASTNode, List<VarComment>> resolvedVarComments;
    private boolean isResolvingVarComments;

    public CommentsVisitor() {
        this(false);
    }

    public CommentsVisitor(boolean resolveVarComments) {
        this.isResolvingVarComments = resolveVarComments;
        this.comments = new ArrayList<Comment>();
        this.resolvedVarComments = new HashMap<ASTNode, List<VarComment>>();
    }

    public boolean visit(Comment comment) {
        ASTNode parent;
        this.comments.add(comment);
        if (this.isResolvingVarComments && comment instanceof VarComment && (parent = Locator.locateNode((Program)comment.getProgramRoot(), (int)Math.max(0, comment.getStart() - 1))) != null) {
            List<VarComment> varComments;
            if (parent.getType() == 6) {
                parent = parent.getParent();
            }
            if ((varComments = this.resolvedVarComments.get(parent)) == null) {
                varComments = new ArrayList<VarComment>(5);
                this.resolvedVarComments.put(parent, varComments);
            }
            varComments.add((VarComment)comment);
        }
        return false;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public Map<ASTNode, List<VarComment>> getResolvedVarComments() {
        return this.resolvedVarComments;
    }
}

